%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate7_Selected.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This file runs the 7 sensor project based on a selected
%                 set of previous results
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

SavePlots = true;
numSensors = 7;

% Note: The previous results must be saved in the file 'Results_7.mat'
% mean7 = 2.7304, 50.7740, 2.3482
% Load in all the data that we are choosing from
load Results_7.mat
deltaE_Idx = 2*numSensors + 1;
MTF50_Idx = 2*numSensors + 2;

FindValues = [  2.707 50.4 ;    % Mean
                2.628 50.4;     % Mean
                2.627 50.6;     % Mean
                3.744 64.2;     % Best Freq
                1.313 53.4];    % Best color
FindIdx = [];
Tol = 0.0001;

% Make a vactor of distances to test
Dist = sqrt(Results7(:,deltaE_Idx).^2 + Results7(:,MTF50_Idx).^2);

for NumIdx = 1:1:size(FindValues,1),
    Val = sqrt(FindValues(NumIdx,1).^2 + FindValues(NumIdx,2).^2);
    Rows = find(abs(Dist - Val) <= Tol);
    FindIdx = [FindIdx ; Rows];
end

FindIdx
Results7(FindIdx,:)

% Save the names of te parameters that we are changing
sensorSettings_Names = {'Width1','Width2','Width3','Width4','Width5',...
    'Width6','Width7','Pos1','Pos2','Pos3','Pos4','Pos5','Pos6','Pos7'};
sensorSettings = Results7(FindIdx,1:2*numSensors);
save('SensorData7.mat', 'sensorSettings_Names', 'sensorSettings');

NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

sensorIndex = 1;
analysisIndex = 1;
save('SavedData7.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');

% Loop through all the sensors
Simulate7_Sub;

% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames7 = sensorSettings_Names;
Results7 = sensorSettings;

Results7 = [Results7 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames7 = {ResultNames7{:},'deltaE','MTF50','yNoise'};

% Display the results
disp(ResultNames7);
disp(Results7);

% Save the final results
save('Results_7_Selected.mat', 'ResultNames7', 'Results7');

% Plot the final results
colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo','MarkerFaceColor','b');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 7 colors');
grid on;
axis([0 max(1.1*frequencyMetrics) 0 max(1.1*colorMetrics)]);

saveas(gcf, ['./Images/Results_7_Selected.eps'],'epsc2');
saveas(gcf, ['./Images/Results_7_Selected.png']);





